// H.Moessenboeck: Sprechen Sie Java? -- Kapitel 7, Aufgabe 6
// "Magisches Quadrat"

class A6 {
	
	// Read a matrix of integers from the input stream
	static int[][] readMatrix() {
		int n = In.readInt();
		int[][] a = new int[n][n];
		for (int i = 0; i < n; i++) 
			for (int j = 0; j < n; j++)
				a[i][j] = In.readInt();
		return a;
	}
	
	// Print a
	static void printMatrix(int[][] a) {
		for (int i = 0; i < a.length; i++) {
			for (int j = 0; j < a[0].length; j++)
				Out.print(a[i][j] + " ");
			Out.println();
		}
		Out.println();
	}
	
	// Check if a is a magic square
	static boolean isMagicSquare(int[][] a) {
		int i, j, sum, n = a.length, magicSum = 0;
		//--- check diagonals
		for (i = 0; i < n; i++) magicSum += a[i][i];
		sum = 0;
		for (i = 0; i < n; i++) sum += a[i][n-i-1];
		if (sum != magicSum) return false;
		//--- check rows
		for (i = 0; i < n; i++) {
			sum = 0;
			for (j = 0; j < n; j++) sum += a[i][j];
			if (sum != magicSum) return false;
		}
		//--- check columns
		for (j = 0; j < n; j++) {
			sum = 0;
			for (i = 0; i < n; i++) sum += a[i][j];
			if (sum != magicSum) return false;
		}
		return true;
	}
	
	public static void main(String[] arg) {
		In.open("input.txt");
		int[][] a = readMatrix();
		Out.println("Eingabe: ");
		printMatrix(a);
		if (isMagicSquare(a))
			Out.println("Die Matrix ist ein magisches Quadrat");
		else
			Out.println("Die Matrix ist kein magisches Quadrat");
		In.close();
	}
}

/*
Sample input:
4
12   6  15   1
13   3  10   8
 2  16   5  11
 7   9   4  14
*/